# BETEL
# this is a rough example how to apply BETEL
# In principle   for spatial QR one should apply spatial blocking before  implementing it
# This is however ignored in this example

rm(list=ls())
# -------------------------------------------------------------------------
# useful if data object has labes to be used in reporting
# not used here
dataprep <- function(data){
    prep <- function(i) assign(eval(names(data)[i]),data[,i],pos=.GlobalEnv)
    a <- sapply(1:ncol(data), prep)
}
# --- used to name global variables(coef's) and assign them values
nmd <- function(alpha,name){
    res <- eval(substitute(paste(name,x,sep=""), list(x=1:length(alpha))))
    mapply(function(i) assign(res[i],alpha[i],env=.GlobalEnv),1:length(alpha) )
#   mapply(function(i) assign(res[i],alpha[i],env= environment(eef),inherits=TRUE),1:length(alpha) )
return(res)
}
# -------------------------------------------------------------------------
betel <- function(par, parname, psi,fprior,parprior){
# would be nice to have input controls here: length of par and lists etc
    lnprior <- rep(999,len=length(par))
    for(j in 1:length(par)) lnprior[j] <- fprior[[j]](par[j],parprior[[j]])
   lnlik <- eefbayes.obj(par,psi=g,parname="alpha")
    lnpost <- sum(lnprior) - lnlik
    res <- exp(lnpost)
return(res)
}
eefbayes.obj <- function(par, parname, psi){
    nm <- nmd(par,parname)
    psimat <- psi(par, X) 
   n <- nrow(psimat)
    tval <- solve(t(psimat)%*%psimat)%*%apply(psimat,2,sum)
    ans <- nlm(function(tval){ sum(exp(tval%*%t(psimat)))/n },tval)
    tval <- ans$estimate; M <- ans$minimum
   llfval <- sum( log(M) - t(tval%*%t(psimat)) )/n
    assign("MM", M, envir=.GlobalEnv,inherits=TRUE ) ; assign("ttval", tval, envir=.GlobalEnv,inherits=TRUE )
return(llfval)
}
# -------------------------------------------------------------------------
# -------------------------------------------------------------------------
fprior.norm <- function(x, parprior){
    res <- log(dnorm(x,mean=parprior[1],sd=sqrt(parprior[2])))
return(res)
}
# -------------------------------------------------------------------------
mcmc <- function(stval, psi, fprior, parprior, nruns = 100, parname="alpha",step_scale=1){
     npar <- length(stval)
     accepted <- rep(0,nruns)
     mcout <- matrix(0,nruns,npar)
     #mapest<-nlm(targetf,stval)
     mcout[1,] <- stval
     oldlik <- betel(stval,psi=psi,parname=parname,fprior=fprior,parprior=parprior)
     for (i in 2:nruns){
			 #cat(".") ;
			if (100*floor(i/100) == i) {cat(".")}
			if (1000*floor(i/1000) == i) {cat(" MC rep: ", i, " \n")}
          mc_prop <- mcout[i-1,]+step_scale*rnorm(npar)
          proplik <- betel(mc_prop,psi=psi,parname=parname,fprior=fprior,parprior=parprior)
          accratio <- exp(log(proplik)-log(oldlik))
          u<-runif(1)
          if(u<accratio)
           {
           mcout[i,] <- mc_prop
           oldlik <- proplik
           accepted[i] <- 1
           }
          else
           mcout[i,] <- mcout[i-1,]
          #print(c(proplik,oldlik,accratio,accepted[i]))
     }
     cat("acceptance ratio =",100*sum(accepted)/nruns,"%\n")
return(mcout)
}
# -------------------------------------------------------------------
#source("N:/My Documents/Papers/In progress/EL-QR/SEL-SQR.r")
# contains EL functions.
#I just add the used ones below
Gu = function(u)
{
    # CDF (based on kernel Ku)
    u = pmin(u, sqrt(5))
    3/(4*sqrt(5))*(u - u^3/15 + 2*sqrt(5)/3)*(abs(u)<=sqrt(5))
}
psi.h = function(u, hn, tau)
{
    # the smoothed quantile score function
    # unsmoothed when hn=0, out = I(u<0) - tau
    if(hn==0) out = 1*(u<0) - tau
    if(hn>0) out = 1-Gu(u/hn) - tau
    return(out)
}

source("N:/My Documents/Papers/In progress/EL-QR/JGSY/IVRQ.r")
#contains code for IVQR estimation

# The next section of code contains some routines for  creating artificial data
# ignore if using real data
##################################################################################
##################################################################################
make.nb= function (n) {
rc=sample.int(n,n,replace=F)
nb= matrix(rc, 10,n/10)
nb
 }

make.rook2=function(nb){
n=nrow(nb)*ncol(nb)
rook=matrix(rep(0,n^2),nrow=n, ncol=n)
####
for (i in 1:10){
    for (j in 1:(n/10)){

     if (j<n/10){
      rook[nb[i,j],nb[i,(j+1)]]<-1
      rook[nb[i,(j+1)],nb[i,j]]<-1
                    }

      if (j>1){
      rook[nb[i,j],nb[i,(j-1)]]<-1
      rook[nb[i,(j-1)],nb[i,j]]<-1
                 }

       if (i<10){
       rook[nb[i,j],nb[(i+1),j]]<-1
       rook[nb[(i+1),j],nb[i,j]]<-1
                    }

       if (i>1){
       rook[nb[i,j],nb[(i-1),j]]<-1
       rook[nb[(i-1),j],nb[i,j]]<-1
                    }
     }
}
require(spdep)
mlist=mat2listw(rook)
nb1=mlist$neighbours
wlist=nb2listw(nb1, style="W")
wlist
}


sim.norm.y= function(n,W){

v= runif(n) #innovations
x0= rnorm(n)
# now get ff
ff=qnorm(v)
# ff=qt(v,3)
#ff=qchisq(p, 3)

lambda = 0.5 + 0.1 *ff
b1=2+0.5*ff
b2=1+0.5*ff
b1+b2*x0   -> yy
II=diag(n)
IM= II-lambda*W
y=solve(IM)%*%yy
param=cbind(lambda, b1, b2)
mdat=x0
list(y,param,mdat)
}

# -------------------------------------------------------------------
# -------------------------------------------------------------------
# -------------------------------------------------------------------
set.seed(123)  #fix the seed to allow replication
n=200
nb=make.nb(n)
wlist=make.rook2(nb)
W=listw2mat(wlist)
res=sim.norm.y(n,W)
param=res[[2]]
y=res[[1]]
x0=res[[3]]

# now 
# y is the dependent variable
# x0 is the independent variable (can be more than 1)
# W is the spatial weighting matrix


Z=  lag.listw(wlist,x0,zero.policy=T) #if more than 1 vars, use  loop
res1=lag.listw(wlist,y,zero.policy=T)

# res1 is the spatially lagged dependent variable (can be more than 1)
##################################################################################
##################################################################################

# To do EL estimation itis better to have some starting values
# below 
#  a gmm estimation is used to obtain these.
# It is more general  (in particular if there is more than 1 endogenoous variable)

# IVQR can be used instead 
# see details  and  second example further below

mtau=0.5

# -------------------------------------------------------------------
# -------------------------------------------------------------------
# -------------------------------------------------------------------
  

require(gmm)
#get some starting values
#if you prefer gmm for starting values
g0 <- function(theta, X) {
e =(X[,1]- rep(theta[1],nrow(X))-X[,2:3]%*%theta[2:3])
E= psi.h(e, hn=1, tau=0.5)
gmat <- cbind(E, E*c(X[,3]), E*c(X[,4]))
gmat
}
X0 <- as.matrix(cbind(y, res1,x0,Z))

m0 <-gmm(g0, x=X0,t0 = rep(0,3))
est.coef0=m0$coefficients

pr0=summary(m0)$coefficients[,1:2]

dimnames(pr0)<-NULL

################################################################################################
#get the g function for the model
g <- function(theta, X) {
e =(X[,1]- rep(theta[1],nrow(X))-X[,2:3]%*%theta[2:3])
E= psi.h(e, hn=n^(-0.25), tau=mtau)
gmat <- cbind(E, E*c(X[,3]), E*c(X[,4]))
gmat
}
X <- as.matrix(cbind(y, res1,x0,Z))

#dataprep(data.frame(y=y,x0=x0,Z=Z,res1=res1) )

 fprior <- list(fprior.norm,fprior.norm,fprior.norm) # normal priors
 parprior <-list(pr0[1,],pr0[2,],pr0[3,])
 #parprior <- list(c(est.coef0[1],0.1),c(est.coef0[2],0.1),c(est.coef0[3],0.1))
 stv <- est.coef0
 nruns <- 10000
 

# adjust step_scale  to get a reasonable acceptance rate
mcmcres <- mcmc(stval=stv,nruns=nruns,psi=g,parname="alpha",fprior=fprior,parprior=parprior,step_scale=0.3)

#burn-in
mcmcres=mcmcres[4001:10000,]
#quick look at approx. CI
apply(mcmcres,2, mean)
#apply(mcmcres,2, quantile, probs=0.5)
apply(mcmcres,2, quantile, probs=0.95)
apply(mcmcres,2, quantile, probs=0.05)


##################################################################################
#using IVQR for starting values
require(quantreg) #for some reason quantrefg is not loade in theIVQR routine
bhat=fit.ivrq(res1,x0,Z,y,tau=mtau)
my.se=se.ivrq(bhat,res1,x0,Z,y,tau=mtau)
#the above will work with just identified case only.
# for more general applications use the qregspiv function in 
# the McSpatial package  (which allows for overidentified cases)
# Make sure you use the IVQR (not the 2SQR) estimator


est.coef=bhat[c(3,1,2)]
pr= my.se[,c(3,1,2)]
pr=t(pr)
pr[,2]<-pr[,2] 
# in principle should be square root of it, but in this example it requires 
# more manipulation to obtain reasonable acceptance rate 

dimnames(pr)<-NULL 

####################################################################################
# and now do it with these starting values (and variance priors)

fprior <- list(fprior.norm,fprior.norm,fprior.norm) # normal priors
parprior <-list(pr[1,],pr[2,],pr[3,])
#parprior <- list(c(est.coef0[1],0.1),c(est.coef0[2],0.1),c(est.coef0[3],0.1))
stv <- est.coef
nruns <- 10000
 
# adjust step_scale  to get a reasonable acceptance rate
mcmcres <- mcmc(stval=stv,nruns=nruns,psi=g,parname="alpha",fprior=fprior,parprior=parprior,step_scale=0.3)

#burn-in 4000
mcmcres=mcmcres[4001:nruns,]

#quick look at approx. CI
apply(mcmcres,2, mean)
#apply(mcmcres,2, quantile, probs=0.5)
apply(mcmcres,2, quantile, probs=0.95)
apply(mcmcres,2, quantile, probs=0.05)



# unless you are interested in the actual convergence
# you can ignore the rest

#####################################################################################
#####################################################################################
# just a quick check on convergence
#run another chain
mcmcres2 <- mcmc(stval=stv,nruns=nruns,psi=g,parname="alpha",fprior=fprior,parprior=parprior,step_scale=0.3)
#burn-in
mcmcres2=mcmcres2[4001:nruns,]

require(coda)
mobj=mcmc.list(as.mcmc(mcmcres),as.mcmc(mcmcres2))

summary(mobj)
plot(mobj)

#check mixing
gelman.diag(mobj)
gelman.plot(mobj)

#check run length
raftery.diag(mobj)
# note the run length for the first parameter 
# blocking should aleviate the problem

heidel.diag(mobj)

#let's now re-estimate 
nruns <- 50000
mcmcres <- mcmc(stval=stv,nruns=nruns,psi=g,parname="alpha",fprior=fprior,parprior=parprior,step_scale=0.3)

mcmcres=mcmcres[4001:nruns]
mobj=as.mcmc(mcmcres)
summary(mobj)
#look at the CI
HPDinterval(mobj, prob = 0.95)

#################################################################################




